//+------------------------------------------------------------------+
//|                               Copyright © 2020, Gehtsoft USA LLC |
//|                                            http://fxcodebase.com |
//+------------------------------------------------------------------+
//|                                      Developed by : Mario Jemic  |
//|                                           mario.jemic@gmail.com  |
//|                          https://AppliedMachineLearning.systems  |
//+------------------------------------------------------------------+
//|                                 Support our efforts by donating  |
//|                                  Paypal : https://goo.gl/9Rj74e  |
//|                                 Patreon : https://goo.gl/GdXWeN  |
//+------------------------------------------------------------------+
// modified by banzai from Mario Jemic template @
// http://fxcodebase.com/code/viewtopic.php?f=38&t=69820
// July 10th, 2020
// not for sale, rent, auction, nor lease

#property copyright "Optimized and Improved Version by tuxTrader"
#property link      "https://www.forexfactory.com/tuxtrader"
//+------------------------------------------------------------------+
//|   AutoPivotIndicator.mq4          ver 4.02           by Habeeb   |
//|                                                                  |
//|          This version solves the Sunday Bar problem.             |
//| Ver4 calculated daily pivots incorrectly when Use_Sunday_Data    |
//|        was set to "False".  Fixed in this version.               |
//+------------------------------------------------------------------+
//  some display upgrades added by Aaragorn 11/27/07


//+---------------------------------------------------------------------+
//  CHANGES by tuxTrader@ForexFactory :                                 |
//                                                                      |
//  Added "Labels_Adjust" & "Lines_Move_to_Right" settings _ 12/22/2019 |
//  Added "Lines_Shift" option.                            _ 12/23/2019 |
//  Minor bug fixes & Code Optimization                    _ 12/23/2019 |
//  Optimized "Lines_Shift" option to shift lines to right _ 12/29/2019 |
//+---------------------------------------------------------------------+

#property indicator_chart_window

   extern bool             Use_Sunday_Data      = true;
   extern bool             Daily                = true;
   extern bool             Daily_SR_Levels      = true;
   extern bool             Weekly               = false;
   extern bool             Weekly_SR_Levels     = false;
   extern bool             Monthly              = false;
   extern bool             Monthly_SR_Levels    = false;
   extern int              Labels_Adjust        = 10;
   extern bool             Lines_Move_to_Right  = false;
   extern int              Lines_Shift          = 0;
extern string              note1                = "------------------------------";
extern string              LineFont             = "Arial Black";
extern int                 FontSize             = 6;
extern ENUM_LINE_STYLE     myLineStyle          = STYLE_DASH;

extern string              DailyLineColors      = "---Daily Colors-------------";
extern color               PivotLine            = clrMagenta;
extern color               R1_Line              = clrRed;
extern color               R2_Line              = clrRed;
extern color               R3_Line              = clrRed;
extern color               S1_Line              = clrGreen;
extern color               S2_Line              = clrGreen;
extern color               S3_Line              = clrGreen;

extern string              WeeklyLineColors     = "---Weekly Colors-------------";
extern color               WeekPivotLine        = clrAqua;
extern color               WR1_Line             = clrDarkOrange;
extern color               WR2_Line             = clrDarkOrange;
extern color               WR3_Line             = clrDarkOrange;
extern color               WS1_Line             = clrSteelBlue;
extern color               WS2_Line             = clrSteelBlue;
extern color               WS3_Line             = clrSteelBlue;

extern string              MonthlyLineColors    = "---Monthly Colors-------------";
extern color               MonthPivotLine       = clrAqua;
extern color               MR1_Line             = clrBlue;
extern color               MR2_Line             = clrBlue;
extern color               MR3_Line             = clrBlue;
extern color               MS1_Line             = clrSilver;
extern color               MS2_Line             = clrSilver;
extern color               MS3_Line             = clrSilver;
//+------------------------------------------------------------------------------------------------------------------+
//template code start1
extern string             button_note1          = "------------------------------";
extern ENUM_BASE_CORNER   btn_corner            = CORNER_RIGHT_UPPER; // chart btn_corner for anchoring
extern string             btn_text              = "Pivot";
extern string             btn_Font              = "Arial";
extern int                btn_FontSize          = 10;                             //btn__font size
extern color              btn_text_color        = clrWhite;
extern color              btn_background_color  = clrDimGray;
extern color              btn_border_color      = clrBlack;
extern int                button_x              = 200;                                     //btn__x
extern int                button_y              = 450;                                     //btn__y
extern int                btn_Width             = 94;                                 //btn__width
extern int                btn_Height            = 20;                                //btn__height
extern string             button_note2          = "------------------------------";
bool                      show_data             = true;
string IndicatorName, IndicatorObjPrefix;
int WorkTime=0,Periods=0;
//template code end1
   double YesterdayHigh;
   double YesterdayLow;
   double YesterdayClose;
   double Day_Price[][6];
   double Pivot,S1,S2,S3,R1,R2,R3;
      
   double WeekHigh;
   double WeekLow;
   double WeekClose;
   double Weekly_Price[][6];
   double WeekPivot,WS1,WS2,WS3,WR1,WR2,WR3;
   
   double MonthHigh;
   double MonthLow;
   double MonthClose;
   double Month_Price[][6];
   double MonthPivot,MS1,MS2,MS3,MR1,MR2,MR3;

   datetime endTime=0, startTime=0;
   bool     PlotFactor=false;
   bool Daily2, Daily_SR_Levels2, Weekly2, Weekly_SR_Levels2, Monthly2, Monthly_SR_Levels2;

//+------------------------------------------------------------------+
//template code start2
string GenerateIndicatorName(const string target) //don't change anything here
{
   string name = target;
   int try = 2;
   while (WindowFind(name) != -1)
   {
      name = target + " #" + IntegerToString(try++);
   }
   return name;
}
//+------------------------------------------------------------------+
class VisibilityCotroller //don't change anything here
{
   string buttonId, visibilityId;
   bool show_data, recalc;
public:
   void Init(string pivotid, string indicatorName, string caption, int x, int y) //don't change anything here
   {
      recalc = false;
      visibilityId = indicatorName + "_visibility";
      double val;
      if (GlobalVariableGet(visibilityId, val))
         show_data = val != 0;
         
      buttonId = pivotid;
      ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, 1);
      createButton(buttonId, caption, btn_Width, btn_Height, btn_Font, btn_FontSize, btn_background_color, btn_border_color, btn_text_color);
      ObjectSetInteger(0,buttonId,OBJPROP_YDISTANCE, button_y);
      ObjectSetInteger(0,buttonId,OBJPROP_XDISTANCE, button_x);
// put init() here

   }
//+------------------------------------------------------------------+
   void DeInit()
   {
      ObjectDelete(ChartID(), buttonId);
      //put deinit () here
        DeleteObjectsByString("Line",0);
        DeleteObjectsByString("Label",0);
   }
//+------------------------------------------------------------------+
   bool HandleButtonClicks() //don't change anything here
   {
      if (ObjectGetInteger(0, buttonId, OBJPROP_STATE))
      {
         ObjectSetInteger(0, buttonId, OBJPROP_STATE, false);
         show_data = !show_data;
         GlobalVariableSet(visibilityId, show_data ? 1.0 : 0.0);
         recalc = true;
         return true;
      }
      return false;
   }
//+------------------------------------------------------------------+
   bool IsRecalcNeeded() //don't change anything here
   {
      return recalc;
   }
//+------------------------------------------------------------------+
   void ResetRecalc() //don't change anything here
   {
      recalc = false;
   }
//+------------------------------------------------------------------+
   bool IsVisible() //don't change anything here
   {
      return show_data;
   }
//+------------------------------------------------------------------+
private: //don't change anything here much
   void createButton(string buttonID,string buttonText,int width,int height,string font,int fontSize,color bgColor,color borderColor,color txtColor)
   {
      ObjectDelete    (0,buttonID);
      ObjectCreate    (0,buttonID,OBJ_BUTTON,0,0,0);
      ObjectSetInteger(0,buttonID,OBJPROP_COLOR,txtColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,bgColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_COLOR,borderColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,width);
      ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,height);
      ObjectSetString (0,buttonID,OBJPROP_FONT,font);
      ObjectSetString (0,buttonID,OBJPROP_TEXT,buttonText);
      ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,fontSize);
      ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,buttonID,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,buttonID,OBJPROP_HIDDEN,1);
   }
};
VisibilityCotroller visibility;
//+------------------------------------------------------------------+
int init()
  {
   IndicatorName = GenerateIndicatorName("AutoPivot"); //don't forget to change the name here
   IndicatorObjPrefix = "__" + IndicatorName + "__";
   IndicatorShortName(IndicatorName);
   IndicatorDigits(Digits);
// Enter another different name below
   visibility.Init("AutoPivotVisibility", IndicatorName, btn_text, button_x, button_y);

//DON'T put the init function here

   return 0;
};
//+------------------------------------------------------------------+
int deinit()  
  {
   visibility.DeInit();
    ObjectsDeleteAll(ChartID(), IndicatorObjPrefix);
    
    //put the deinit function here
        DeleteObjectsByString("Line",0);
        DeleteObjectsByString("Label",0);
    
   return(0);
  }
//+------------------------------------------------------------------+
void OnChartEvent(const int pivotid, //don't change anything here
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
   if (visibility.HandleButtonClicks())
      start();
}
//+------------------------------------------------------------------+
//template end2
int start2()
{

ArrayCopyRates(Day_Price,(Symbol()), 1440);



   YesterdayHigh  = Day_Price[1][3];
   YesterdayLow   = Day_Price[1][2];
   YesterdayClose = Day_Price[1][4];
   
   Pivot = ((YesterdayHigh + YesterdayLow + YesterdayClose)/3);

   R1 = (2*Pivot)-YesterdayLow;
   S1 = (2*Pivot)-YesterdayHigh;

   R2 = Pivot+(R1-S1);
   S2 = Pivot-(R1-S1);
   
   R3 = (YesterdayHigh + (2*(Pivot-YesterdayLow)));
   S3 = (YesterdayLow - (2*(YesterdayHigh-Pivot)));  
  
  
if (Use_Sunday_Data == false)
 {   
   while (DayOfWeek() == 1)
      {  
       YesterdayHigh  = Day_Price[2][3];
       YesterdayLow   = Day_Price[2][2];
       YesterdayClose = Day_Price[2][4];
   
       Pivot = ((YesterdayHigh + YesterdayLow + YesterdayClose)/3);

       R1 = (2*Pivot)-YesterdayLow;
       S1 = (2*Pivot)-YesterdayHigh;

       R2 = Pivot+(R1-S1);
       S2 = Pivot-(R1-S1);
   
       R3 = (YesterdayHigh + (2*(Pivot-YesterdayLow)));
       S3 = (YesterdayLow - (2*(YesterdayHigh-Pivot)));
       break;
      }
 }


//--------------------------------------------------------
//--------------------------------------------------------


ArrayCopyRates(Weekly_Price, Symbol(), 10080);

WeekHigh  = Weekly_Price[1][3];
WeekLow   = Weekly_Price[1][2];
WeekClose = Weekly_Price[1][4];

WeekPivot = ((WeekHigh + WeekLow + WeekClose)/3);

      WR1 = (2*WeekPivot)-WeekLow;
      WS1 = (2*WeekPivot)-WeekHigh;

      WR2 = WeekPivot+(WR1-WS1);
      WS2 = WeekPivot-(WR1-WS1);

      WS3 = (WeekLow - (2*(WeekHigh-WeekPivot)));
      WR3 = (WeekHigh + (2*(WeekPivot-WeekLow)));

//--------------------------------------------------------
//--------------------------------------------------------


ArrayCopyRates(Month_Price, Symbol(), 43200);

MonthHigh  = Month_Price[1][3];
MonthLow   = Month_Price[1][2];
MonthClose = Month_Price[1][4];

MonthPivot = ((MonthHigh + MonthLow + MonthClose)/3);

      MR1 = (2*MonthPivot)-MonthLow;
      MS1 = (2*MonthPivot)-MonthHigh;

      MR2 = MonthPivot+(MR1-MS1);
      MS2 = MonthPivot-(MR1-MS1);

      MS3 = (MonthLow - (2*(MonthHigh-MonthPivot)));
      MR3 = (MonthHigh + (2*(MonthPivot-MonthLow)));


//--------------------------------------------------------
//--------------------------------------------------------


if (Daily==true)
{
 DrawLine("PivotLine","PivotLabel","DP",Pivot,Magenta);

 if (Daily_SR_Levels==true)
 {
   DrawLine("R1_Line","R1_Label","DR1",R1,Red);
   DrawLine("R2_Line","R2_Label","DR2",R2,Red);
   DrawLine("R3_Line","R3_Label","DR3",R3,Red);

   DrawLine("S1_Line","S1_Label","DS1",S1,Green);
   DrawLine("S2_Line","S2_Label","DS2",S2,Green);
   DrawLine("S3_Line","S3_Label","DS3",S3,Green);
 }
}

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

if (Weekly==true)
{
 DrawLine("WeekPivotLine","WeekPivotLabel","WP",WeekPivot,Aqua);

 if (Weekly_SR_Levels==true)
 {
   DrawLine("WR1_Line","WR1_Label","WR1",WR1,DarkOrange);
   DrawLine("WR2_Line","WR2_Label","WR2",WR2,DarkOrange);
   DrawLine("WR3_Line","WR3_Label","WR3",WR3,DarkOrange);

   DrawLine("WS1_Line","WS1_Label","WS1",WS1,SteelBlue);
   DrawLine("WS2_Line","WS2_Label","WS2",WS2,SteelBlue);
   DrawLine("WS3_Line","WS3_Label","WS3",WS3,SteelBlue);
 }
}

//---------------------------------------------------------
//---------------------------------------------------------
//---------------------------------------------------------

if (Monthly==true)
{
 DrawLine("MonthPivotLine","MonthPivotLabel","MP",MonthPivot,Plum);

 if (Monthly_SR_Levels==true)
 {
   DrawLine("MR1_Line","MR1_Label","MR1",MR1,Blue);
   DrawLine("MR2_Line","MR2_Label","MR2",MR2,Blue);
   DrawLine("MR3_Line","MR3_Label","MR3",MR3,Blue);

   DrawLine("MS1_Line","MS1_Label","MS1",MS1,Silver);
   DrawLine("MS2_Line","MS2_Label","MS2",MS2,Silver);
   DrawLine("MS3_Line","MS3_Label","MS3",MS3,Silver);
 }
}

   return(0); //start2()
}
//--------------------------------------------------------
int start()
{
//template start3
   visibility.HandleButtonClicks();
   visibility.ResetRecalc();
   
   if (visibility.IsVisible())
   {
//template end3

//now, put the start() here
      start2();
      
//template start4
      if( (WorkTime != Time[0]) || (Periods != Period()) ) 
      {
         if (show_data) // on button
         {
           start2();
         }
         else //off button
         {
           DeleteObjectsByString("Line",0);
           DeleteObjectsByString("Label",0);
         } // else off button
      } //if( (WorkTime != Time[0]) || (Periods != Period()) )
   } //if (visibility.IsVisible())
   else //again, copy the off button function here
   {
           DeleteObjectsByString("Line",0);
           DeleteObjectsByString("Label",0);
   } //else
//template end4  
   return(0);
}
//+---------------------------------------------------------------------+
void DrawLine(string LineName, string LabelName, string LabelText, double Price, color COLOR)
{
   startTime=0;  endTime=0;
   if(Lines_Move_to_Right)  { startTime = Time[0]+(Period()*60*Lines_Shift);  endTime = startTime + (Period()*60*1);                 PlotFactor=true; }
   else                     { startTime = iTime(Symbol(),PERIOD_D1,-1);       endTime = iTime(Symbol(),PERIOD_D1,0)+(PERIOD_D1*60);  PlotFactor=true; }

  ObjectCreate(LineName, OBJ_TREND,0,startTime,Price,endTime,Price);
  ObjectSet   (LineName, OBJPROP_TIME1, startTime);
  ObjectSet   (LineName, OBJPROP_TIME2, endTime);
  ObjectSet   (LineName, OBJPROP_COLOR, COLOR);
  ObjectSet   (LineName, OBJPROP_STYLE, myLineStyle);
  ObjectSet   (LineName, OBJPROP_RAY,   PlotFactor);
  ObjectSet   (LineName, OBJPROP_SELECTABLE, false);
  ObjectSet   (LineName, OBJPROP_SELECTED, false);  
  ObjectSet   (LineName, OBJPROP_HIDDEN, true);
  ObjectMove  (LineName, 1, endTime, Price);
  ObjectMove  (LineName, 0, startTime, Price);

  if(ObjectFind(LabelName) != 0)
  {
   ObjectCreate(LabelName, OBJ_TEXT, 0, Time[0]+(Period()*60*Labels_Adjust), Price);
   ObjectSetText(LabelName, LabelText, FontSize, LineFont, COLOR);
  }
  else
  {
   ObjectMove(LabelName, 0, Time[0]+(Period()*60*Labels_Adjust), Price);
   ObjectMove(LineName, 0, startTime,Price);

  }

  ObjectsRedraw();
  WindowRedraw();
}
//---------------------------------------------------------
void DeleteObjectsByString(string Search,int SubWin, int ObjectType=-1) {
   int TotalObject = ObjectsTotal(0,SubWin,-1);
   for (int i = TotalObject; i >= 0 ; i--)
   {
      if (StringFind(ObjectName(0, i, SubWin, ObjectType), Search, 0) > -1)
      {
         ObjectDelete(0,ObjectName(0,i,SubWin,-1));
      }      
   }
}
//---------------------------------------------------------
